/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.platform;

import java.util.function.BiFunction;
import me.ultrusmods.missingwilds.block.CustomWaterlilyBlock;
import me.ultrusmods.missingwilds.compat.ForgeModCompatHandler;
import me.ultrusmods.missingwilds.entity.FireflySwarm;
import me.ultrusmods.missingwilds.item.MissingWildsItemGroup;
import me.ultrusmods.missingwilds.platform.services.IPlatformHelper;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public CreativeModeTab getCreativeTab() {
        return MissingWildsItemGroup.MISSING_WILDS;
    }

    @Override
    public void setBlockRenderType(RenderType layer, Block ... blocks) {
        for (Block block : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)layer);
        }
    }

    @Override
    public void duringItemRegistering() {
        if (this.isModLoaded("brrp_v1")) {
            ForgeModCompatHandler.registerModCompatItems();
        }
    }

    @Override
    public void duringBlockRegistering() {
        if (this.isModLoaded("brrp_v1")) {
            ForgeModCompatHandler.registerModCompatBlocks();
        }
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> buildBlockEntity(BiFunction<BlockPos, BlockState, T> supplier, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(supplier::apply, (Block[])blocks).m_58966_(null);
    }

    @Override
    public EntityType<FireflySwarm> createFirefly() {
        return EntityType.Builder.m_20704_(FireflySwarm::new, (MobCategory)MobCategory.AMBIENT).m_20699_(2.0f, 2.0f).m_20702_(16).m_20712_("firefly_swarm");
    }

    @Override
    public Block getWaterlilyBlock(BlockBehaviour.Properties properties) {
        return new CustomWaterlilyBlock(properties);
    }
}

